/*!
 * # Semantic UI 2.1.7 - Dropdown
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.dropdown=function(a){var o,s=e(this),r=e(n),l=s.selector||"",c="ontouchstart"in n.documentElement,u=(new Date).getTime(),d=[],v=arguments[0],m="string"==typeof v,f=[].slice.call(arguments,1);return s.each(function(h){var g,p,b,w,x,C,S,y=e.isPlainObject(a)?e.extend(!0,{},e.fn.dropdown.settings,a):e.extend({},e.fn.dropdown.settings),T=y.className,A=y.message,k=y.fields,L=y.keys,D=y.metadata,I=y.namespace,R=y.regExp,q=y.selector,V=y.error,E=y.templates,O="."+I,F="module-"+I,P=e(this),M=e(y.context),H=P.find(q.text),z=P.find(q.search),j=P.find(q.input),U=P.find(q.icon),N=P.prev().find(q.text).length>0?P.prev().find(q.text):P.prev(),B=P.children(q.menu),W=B.find(q.item),K=!1,$=!1,Q=!1,Y=this,G=P.data(F);S={initialize:function(){S.debug("Initializing dropdown",y),S.is.alreadySetup()?S.setup.reference():(S.setup.layout(),S.refreshData(),S.save.defaults(),S.restore.selected(),S.create.id(),S.bind.events(),S.observeChanges(),S.instantiate())},instantiate:function(){S.verbose("Storing instance of dropdown",S),G=S,P.data(F,S)},destroy:function(){S.verbose("Destroying previous dropdown",P),S.remove.tabbable(),P.off(O).removeData(F),B.off(O),r.off(b),x&&x.disconnect(),C&&C.disconnect()},observeChanges:function(){"MutationObserver"in t&&(x=new MutationObserver(function(e){S.debug("<select> modified, recreating menu"),S.setup.select()}),C=new MutationObserver(function(e){S.debug("Menu modified, updating selector cache"),S.refresh()}),S.has.input()&&x.observe(j[0],{childList:!0,subtree:!0}),S.has.menu()&&C.observe(B[0],{childList:!0,subtree:!0}),S.debug("Setting up mutation observer",x,C))},create:{id:function(){w=(Math.random().toString(16)+"000000000").substr(2,8),b="."+w,S.verbose("Creating unique id for element",w)},userChoice:function(t){var n,a,o;return(t=t||S.get.userValues())?(t=e.isArray(t)?t:[t],e.each(t,function(t,s){S.get.item(s)===!1&&(o=y.templates.addition(S.add.variables(A.addResult,s)),a=e("<div />").html(o).attr("data-"+D.value,s).attr("data-"+D.text,s).addClass(T.addition).addClass(T.item),n=n===i?a:n.add(a),S.verbose("Creating user choices for value",s,a))}),n):!1},userLabels:function(t){var n=S.get.userValues();n&&(S.debug("Adding user labels",n),e.each(n,function(e,t){S.verbose("Adding custom user value"),S.add.label(t,t)}))},menu:function(){B=e("<div />").addClass(T.menu).appendTo(P)}},search:function(e){e=e!==i?e:S.get.query(),S.verbose("Searching for query",e),S.filter(e)},select:{firstUnfiltered:function(){S.verbose("Selecting first non-filtered element"),S.remove.selectedItem(),W.not(q.unselectable).eq(0).addClass(T.selected)},nextAvailable:function(e){e=e.eq(0);var t=e.nextAll(q.item).not(q.unselectable).eq(0),n=e.prevAll(q.item).not(q.unselectable).eq(0),i=t.length>0;i?(S.verbose("Moving selection to",t),t.addClass(T.selected)):(S.verbose("Moving selection to",n),n.addClass(T.selected))}},setup:{api:function(){var e={debug:y.debug,on:!1};S.verbose("First request, initializing API"),P.api(e)},layout:function(){P.is("select")&&(S.setup.select(),S.setup.returnedObject()),S.has.menu()||S.create.menu(),S.is.search()&&!S.has.search()&&(S.verbose("Adding search input"),z=e("<input />").addClass(T.search).prop("autocomplete","off").insertBefore(H)),y.allowTab&&S.set.tabbable()},select:function(){var t=S.get.selectValues();S.debug("Dropdown initialized on a select",t),P.is("select")&&(j=P),j.parent(q.dropdown).length>0?(S.debug("UI dropdown already exists. Creating dropdown menu only"),P=j.closest(q.dropdown),S.has.menu()||S.create.menu(),B=P.children(q.menu),S.setup.menu(t)):(S.debug("Creating entire dropdown from select"),P=e("<div />").attr("class",j.attr("class")).addClass(T.selection).addClass(T.dropdown).html(E.dropdown(t)).insertBefore(j),j.hasClass(T.multiple)&&j.prop("multiple")===!1&&(S.error(V.missingMultiple),j.prop("multiple",!0)),j.is("[multiple]")&&S.set.multiple(),j.prop("disabled")&&(S.debug("Disabling dropdown"),P.addClass(T.disabled)),j.removeAttr("class").detach().prependTo(P)),S.refresh()},menu:function(e){B.html(E.menu(e,k)),W=B.find(q.item)},reference:function(){S.debug("Dropdown behavior was called on select, replacing with closest dropdown"),P=P.parent(q.dropdown),S.refresh(),S.setup.returnedObject(),m&&(G=S,S.invoke(v))},returnedObject:function(){var e=s.slice(0,h),t=s.slice(h+1);s=e.add(P).add(t)}},refresh:function(){S.refreshSelectors(),S.refreshData()},refreshSelectors:function(){S.verbose("Refreshing selector cache"),H=P.find(q.text),z=P.find(q.search),j=P.find(q.input),U=P.find(q.icon),N=P.prev().find(q.text).length>0?P.prev().find(q.text):P.prev(),B=P.children(q.menu),W=B.find(q.item)},refreshData:function(){S.verbose("Refreshing cached metadata"),W.removeData(D.text).removeData(D.value),P.removeData(D.defaultText).removeData(D.defaultValue).removeData(D.placeholderText)},toggle:function(){S.verbose("Toggling menu visibility"),S.is.active()?S.hide():S.show()},show:function(t){if(t=e.isFunction(t)?t:function(){},S.can.show()&&!S.is.active()){if(S.debug("Showing dropdown"),S.is.multiple()&&!S.has.search()&&S.is.allFiltered())return!0;!S.has.message()||S.has.maxSelections()||S.has.allResultsFiltered()||S.remove.message(),y.onShow.call(Y)!==!1&&S.animate.show(function(){S.can.click()&&S.bind.intent(),S.set.visible(),t.call(Y)})}},hide:function(t){t=e.isFunction(t)?t:function(){},S.is.active()&&(S.debug("Hiding dropdown"),y.onHide.call(Y)!==!1&&S.animate.hide(function(){S.remove.visible(),t.call(Y)}))},hideOthers:function(){S.verbose("Finding other dropdowns to hide"),s.not(P).has(q.menu+"."+T.visible).dropdown("hide")},hideMenu:function(){S.verbose("Hiding menu  instantaneously"),S.remove.active(),S.remove.visible(),B.transition("hide")},hideSubMenus:function(){var e=B.children(q.item).find(q.menu);S.verbose("Hiding sub menus",e),e.transition("hide")},bind:{events:function(){c&&S.bind.touchEvents(),S.bind.keyboardEvents(),S.bind.inputEvents(),S.bind.mouseEvents()},touchEvents:function(){S.debug("Touch device detected binding additional touch events"),S.is.searchSelection()||S.is.single()&&P.on("touchstart"+O,S.event.test.toggle),B.on("touchstart"+O,q.item,S.event.item.mouseenter)},keyboardEvents:function(){S.verbose("Binding keyboard events"),P.on("keydown"+O,S.event.keydown),S.has.search()&&P.on(S.get.inputEvent()+O,q.search,S.event.input),S.is.multiple()&&r.on("keydown"+b,S.event.document.keydown)},inputEvents:function(){S.verbose("Binding input change events"),P.on("change"+O,q.input,S.event.change)},mouseEvents:function(){S.verbose("Binding mouse events"),S.is.multiple()&&P.on("click"+O,q.label,S.event.label.click).on("click"+O,q.remove,S.event.remove.click),S.is.searchSelection()?(P.on("mousedown"+O,q.menu,S.event.menu.mousedown).on("mouseup"+O,q.menu,S.event.menu.mouseup).on("click"+O,q.icon,S.event.icon.click).on("click"+O,q.search,S.show).on("focus"+O,q.search,S.event.search.focus).on("blur"+O,q.search,S.event.search.blur).on("click"+O,q.text,S.event.text.focus),S.is.multiple()&&P.on("click"+O,S.event.click)):("click"==y.on?P.on("click"+O,q.icon,S.event.icon.click).on("click"+O,S.event.test.toggle):"hover"==y.on?P.on("mouseenter"+O,S.delay.show).on("mouseleave"+O,S.delay.hide):P.on(y.on+O,S.toggle),P.on("mousedown"+O,S.event.mousedown).on("mouseup"+O,S.event.mouseup).on("focus"+O,S.event.focus).on("blur"+O,S.event.blur)),B.on("mouseenter"+O,q.item,S.event.item.mouseenter).on("mouseleave"+O,q.item,S.event.item.mouseleave).on("click"+O,q.item,S.event.item.click)},intent:function(){S.verbose("Binding hide intent event to document"),c&&r.on("touchstart"+b,S.event.test.touch).on("touchmove"+b,S.event.test.touch),r.on("click"+b,S.event.test.hide)}},unbind:{intent:function(){S.verbose("Removing hide intent event from document"),c&&r.off("touchstart"+b).off("touchmove"+b),r.off("click"+b)}},filter:function(e){var t=e!==i?e:S.get.query(),n=function(){S.is.multiple()&&S.filterActive(),S.select.firstUnfiltered(),S.has.allResultsFiltered()?y.onNoResults.call(Y,t)?y.allowAdditions||(S.verbose("All items filtered, showing message",t),S.add.message(A.noResults)):(S.verbose("All items filtered, hiding dropdown",t),S.hideMenu()):S.remove.message(),y.allowAdditions&&S.add.userSuggestion(e),S.is.searchSelection()&&S.can.show()&&S.is.focusedOnSearch()&&S.show()};y.useLabels&&S.has.maxSelections()||(y.apiSettings?S.can.useAPI()?S.queryRemote(t,function(){n()}):S.error(V.noAPI):(S.filterItems(t),n()))},queryRemote:function(t,n){var i={errorDuration:!1,throttle:y.throttle,urlData:{query:t},onError:function(){S.add.message(A.serverError),n()},onFailure:function(){S.add.message(A.serverError),n()},onSuccess:function(e){S.remove.message(),S.setup.menu({values:e[k.remoteValues]}),n()}};P.api("get request")||S.setup.api(),i=e.extend(!0,{},i,y.apiSettings),P.api("setting",i).api("query")},filterItems:function(t){var n=t!==i?t:S.get.query(),a=null,o=S.escape.regExp(n),s=new RegExp("^"+o,"igm");S.has.query()&&(a=[],S.verbose("Searching for matching values",n),W.each(function(){var t,i,o=e(this);if("both"==y.match||"text"==y.match){if(t=String(S.get.choiceText(o,!1)),-1!==t.search(s))return a.push(this),!0;if(y.fullTextSearch&&S.fuzzySearch(n,t))return a.push(this),!0}if("both"==y.match||"value"==y.match){if(i=String(S.get.choiceValue(o,t)),-1!==i.search(s))return a.push(this),!0;if(y.fullTextSearch&&S.fuzzySearch(n,i))return a.push(this),!0}})),S.debug("Showing only matched items",n),S.remove.filteredItem(),a&&W.not(a).addClass(T.filtered)},fuzzySearch:function(e,t){var n=t.length,i=e.length;if(e=e.toLowerCase(),t=t.toLowerCase(),i>n)return!1;if(i===n)return e===t;e:for(var a=0,o=0;i>a;a++){for(var s=e.charCodeAt(a);n>o;)if(t.charCodeAt(o++)===s)continue e;return!1}return!0},filterActive:function(){y.useLabels&&W.filter("."+T.active).addClass(T.filtered)},focusSearch:function(){S.is.search()&&!S.is.focusedOnSearch()&&z[0].focus()},forceSelection:function(){var e=W.not(T.filtered).filter("."+T.selected).eq(0),t=W.not(T.filtered).filter("."+T.active).eq(0),n=e.length>0?e:t,i=n.size()>0;if(S.has.query()){if(i)return S.debug("Forcing partial selection to selected item",n),void S.event.item.click.call(n);S.remove.searchTerm()}S.hide()},event:{change:function(){Q||(S.debug("Input changed, updating selection"),S.set.selected())},focus:function(){y.showOnFocus&&!K&&S.is.hidden()&&!p&&S.show()},click:function(t){var n=e(t.target);n.is(P)&&!S.is.focusedOnSearch()&&S.focusSearch()},blur:function(e){p=n.activeElement===this,K||p||(S.remove.activeLabel(),S.hide())},mousedown:function(){K=!0},mouseup:function(){K=!1},search:{focus:function(){K=!0,S.is.multiple()&&S.remove.activeLabel(),y.showOnFocus&&(S.search(),S.show())},blur:function(e){p=n.activeElement===this,$||p?p&&y.forceSelection&&S.forceSelection():S.is.multiple()?(S.remove.activeLabel(),S.hide()):y.forceSelection?S.forceSelection():S.hide()}},icon:{click:function(e){S.toggle(),e.stopPropagation()}},text:{focus:function(e){K=!0,S.focusSearch()}},input:function(e){(S.is.multiple()||S.is.searchSelection())&&S.set.filtered(),clearTimeout(S.timer),S.timer=setTimeout(S.search,y.delay.search)},label:{click:function(t){var n=e(this),i=P.find(q.label),a=i.filter("."+T.active),o=n.nextAll("."+T.active),s=n.prevAll("."+T.active),r=o.length>0?n.nextUntil(o).add(a).add(n):n.prevUntil(s).add(a).add(n);t.shiftKey?(a.removeClass(T.active),r.addClass(T.active)):t.ctrlKey?n.toggleClass(T.active):(a.removeClass(T.active),n.addClass(T.active)),y.onLabelSelect.apply(this,i.filter("."+T.active))}},remove:{click:function(){var t=e(this).parent();t.hasClass(T.active)?S.remove.activeLabels():S.remove.activeLabels(t)}},test:{toggle:function(e){var t=S.is.multiple()?S.show:S.toggle;S.determine.eventOnElement(e,t)&&e.preventDefault()},touch:function(e){S.determine.eventOnElement(e,function(){"touchstart"==e.type?S.timer=setTimeout(function(){S.hide()},y.delay.touch):"touchmove"==e.type&&clearTimeout(S.timer)}),e.stopPropagation()},hide:function(e){S.determine.eventInModule(e,S.hide)}},menu:{mousedown:function(){$=!0},mouseup:function(){$=!1}},item:{mouseenter:function(t){var n=e(this).children(q.menu),i=e(this).siblings(q.item).children(q.menu);n.length>0&&(clearTimeout(S.itemTimer),S.itemTimer=setTimeout(function(){S.verbose("Showing sub-menu",n),e.each(i,function(){S.animate.hide(!1,e(this))}),S.animate.show(!1,n)},y.delay.show),t.preventDefault())},mouseleave:function(t){var n=e(this).children(q.menu);n.length>0&&(clearTimeout(S.itemTimer),S.itemTimer=setTimeout(function(){S.verbose("Hiding sub-menu",n),S.animate.hide(!1,n)},y.delay.hide))},touchend:function(){},click:function(t){var n=e(this),i=e(t?t.target:""),a=n.find(q.menu),o=S.get.choiceText(n),s=S.get.choiceValue(n,o),r=a.length>0,l=a.find(i).length>0;l||r&&!y.allowCategorySelection||(y.useLabels||(S.remove.filteredItem(),S.remove.searchTerm(),S.set.scrollPosition(n)),S.determine.selectAction.call(this,o,s))}},document:{keydown:function(e){var t=e.which,n=S.is.inObject(t,L);if(n){var i=P.find(q.label),a=i.filter("."+T.active),o=(a.data(D.value),i.index(a)),s=i.length,r=a.length>0,l=a.length>1,c=0===o,u=o+1==s,d=S.is.searchSelection(),v=S.is.focusedOnSearch(),m=S.is.focused(),f=v&&0===S.get.caretPosition();if(d&&!r&&!v)return;t==L.leftArrow?!m&&!f||r?r&&(e.shiftKey?S.verbose("Adding previous label to selection"):(S.verbose("Selecting previous label"),i.removeClass(T.active)),c&&!l?a.addClass(T.active):a.prev(q.siblingLabel).addClass(T.active).end(),e.preventDefault()):(S.verbose("Selecting previous label"),i.last().addClass(T.active)):t==L.rightArrow?(m&&!r&&i.first().addClass(T.active),r&&(e.shiftKey?S.verbose("Adding next label to selection"):(S.verbose("Selecting next label"),i.removeClass(T.active)),u?d?v?i.removeClass(T.active):S.focusSearch():l?a.next(q.siblingLabel).addClass(T.active):a.addClass(T.active):a.next(q.siblingLabel).addClass(T.active),e.preventDefault())):t==L.deleteKey||t==L.backspace?r?(S.verbose("Removing active labels"),u&&d&&!v&&S.focusSearch(),a.last().next(q.siblingLabel).addClass(T.active),S.remove.activeLabels(a),e.preventDefault()):f&&!r&&t==L.backspace&&(S.verbose("Removing last label on input backspace"),a=i.last().addClass(T.active),S.remove.activeLabels(a)):a.removeClass(T.active)}}},keydown:function(e){var t=e.which,n=S.is.inObject(t,L);if(n){var i,a,o=W.not(q.unselectable).filter("."+T.selected).eq(0),s=B.children("."+T.active).eq(0),r=o.length>0?o:s,l=r.length>0?r.siblings(":not(."+T.filtered+")").andSelf():B.children(":not(."+T.filtered+")"),c=r.children(q.menu),u=r.closest(q.menu),d=u.hasClass(T.visible)||u.hasClass(T.animating)||u.parent(q.menu).length>0,v=c.length>0,m=r.length>0,f=r.not(q.unselectable).length>0,h=t==L.delimiter&&y.allowAdditions&&S.is.multiple();if(S.is.visible()){if((t==L.enter||h)&&(t==L.enter&&m&&v&&!y.allowCategorySelection?(S.verbose("Pressed enter on unselectable category, opening sub menu"),t=L.rightArrow):f&&(S.verbose("Selecting item from keyboard shortcut",r),S.event.item.click.call(r,e),S.is.searchSelection()&&S.remove.searchTerm()),e.preventDefault()),t==L.leftArrow&&(a=u[0]!==B[0],a&&(S.verbose("Left key pressed, closing sub-menu"),S.animate.hide(!1,u),r.removeClass(T.selected),u.closest(q.item).addClass(T.selected),e.preventDefault())),t==L.rightArrow&&v&&(S.verbose("Right key pressed, opening sub-menu"),S.animate.show(!1,c),r.removeClass(T.selected),c.find(q.item).eq(0).addClass(T.selected),e.preventDefault()),t==L.upArrow){if(i=m&&d?r.prevAll(q.item+":not("+q.unselectable+")").eq(0):W.eq(0),l.index(i)<0)return S.verbose("Up key pressed but reached top of current menu"),void e.preventDefault();S.verbose("Up key pressed, changing active item"),r.removeClass(T.selected),i.addClass(T.selected),S.set.scrollPosition(i),e.preventDefault()}if(t==L.downArrow){if(i=m&&d?i=r.nextAll(q.item+":not("+q.unselectable+")").eq(0):W.eq(0),0===i.length)return S.verbose("Down key pressed but reached bottom of current menu"),void e.preventDefault();S.verbose("Down key pressed, changing active item"),W.removeClass(T.selected),i.addClass(T.selected),S.set.scrollPosition(i),e.preventDefault()}t==L.pageUp&&(S.scrollPage("up"),e.preventDefault()),t==L.pageDown&&(S.scrollPage("down"),e.preventDefault()),t==L.escape&&(S.verbose("Escape key pressed, closing dropdown"),S.hide())}else h&&e.preventDefault(),t==L.downArrow&&(S.verbose("Down key pressed, showing dropdown"),S.show(),e.preventDefault())}else S.is.selection()&&!S.is.search()&&S.set.selectedLetter(String.fromCharCode(t))}},trigger:{change:function(){var e=n.createEvent("HTMLEvents"),t=j[0];t&&(S.verbose("Triggering native change event"),e.initEvent("change",!0,!1),t.dispatchEvent(e))}},determine:{selectAction:function(t,n){S.verbose("Determining action",y.action),e.isFunction(S.action[y.action])?(S.verbose("Triggering preset action",y.action,t,n),S.action[y.action].call(this,t,n)):e.isFunction(y.action)?(S.verbose("Triggering user action",y.action,t,n),y.action.call(this,t,n)):S.error(V.action,y.action)},eventInModule:function(t,i){var a=e(t.target),o=a.closest(n.documentElement).length>0,s=a.closest(P).length>0;return i=e.isFunction(i)?i:function(){},o&&!s?(S.verbose("Triggering event",i),i(),!0):(S.verbose("Event occurred in dropdown, canceling callback"),!1)},eventOnElement:function(t,n){var i=e(t.target),a=i.closest(q.siblingLabel),o=0===P.find(a).length,s=0===i.closest(B).length;return n=e.isFunction(n)?n:function(){},o&&s?(S.verbose("Triggering event",n),n(),!0):(S.verbose("Event occurred in dropdown menu, canceling callback"),!1)}},action:{nothing:function(){},activate:function(t,n){if(n=n!==i?n:t,S.can.activate(e(this))){if(S.set.selected(n,e(this)),S.is.multiple()&&!S.is.allFiltered())return;S.hideAndClear()}},select:function(e,t){S.action.activate.call(this)},combo:function(t,n){n=n!==i?n:t,S.set.selected(n,e(this)),S.hideAndClear()},hide:function(e,t){S.set.value(t),S.hideAndClear()}},get:{id:function(){return w},defaultText:function(){return P.data(D.defaultText)},defaultValue:function(){return P.data(D.defaultValue)},placeholderText:function(){return P.data(D.placeholderText)||""},text:function(){return H.text()},query:function(){return e.trim(z.val())},searchWidth:function(e){return e*y.glyphWidth+"em"},selectionCount:function(){var t,n=S.get.values();return t=S.is.multiple()?e.isArray(n)?n.length:0:""!==S.get.value()?1:0},transition:function(e){return"auto"==y.transition?S.is.upward(e)?"slide up":"slide down":y.transition},userValues:function(){var t=S.get.values();return t?(t=e.isArray(t)?t:[t],e.grep(t,function(e){return S.get.item(e)===!1})):!1},uniqueArray:function(t){return e.grep(t,function(n,i){return e.inArray(n,t)===i})},caretPosition:function(){var e,t,i=z.get(0);return"selectionStart"in i?i.selectionStart:n.selection?(i.focus(),e=n.selection.createRange(),t=e.text.length,e.moveStart("character",-i.value.length),e.text.length-t):void 0},value:function(){var t=j.length>0?j.val():P.data(D.value);return e.isArray(t)&&1===t.length&&""===t[0]?"":t},values:function(){var e=S.get.value();return""===e?"":!S.has.selectInput()&&S.is.multiple()?"string"==typeof e?e.split(y.delimiter):"":e},remoteValues:function(){var t=S.get.values(),n=!1;return t&&("string"==typeof t&&(t=[t]),n={},e.each(t,function(e,t){var i=S.read.remoteData(t);S.verbose("Restoring value from session data",i,t),n[t]=i?i:t})),n},choiceText:function(t,n){return n=n!==i?n:y.preserveHTML,t?(t.find(q.menu).length>0&&(S.verbose("Retreiving text of element with sub-menu"),t=t.clone(),t.find(q.menu).remove(),t.find(q.menuIcon).remove()),t.data(D.text)!==i?t.data(D.text):n?e.trim(t.html()):e.trim(t.text())):void 0},choiceValue:function(t,n){return n=n||S.get.choiceText(t),t?t.data(D.value)!==i?String(t.data(D.value)):"string"==typeof n?e.trim(n.toLowerCase()):String(n):!1},inputEvent:function(){var e=z[0];return e?e.oninput!==i?"input":e.onpropertychange!==i?"propertychange":"keyup":!1},selectValues:function(){var t={};return t.values=[],P.find("option").each(function(){var n=e(this),a=n.html(),o=n.attr("disabled"),s=n.attr("value")!==i?n.attr("value"):a;"auto"===y.placeholder&&""===s?t.placeholder=a:t.values.push({name:a,value:s,disabled:o})}),y.placeholder&&"auto"!==y.placeholder&&(S.debug("Setting placeholder value to",y.placeholder),t.placeholder=y.placeholder),y.sortSelect?(t.values.sort(function(e,t){return e.name>t.name?1:-1}),S.debug("Retrieved and sorted values from select",t)):S.debug("Retreived values from select",t),t},activeItem:function(){return W.filter("."+T.active)},selectedItem:function(){var e=W.not(q.unselectable).filter("."+T.selected);return e.length>0?e:W.eq(0)},itemWithAdditions:function(e){var t=S.get.item(e),n=S.create.userChoice(e),i=n&&n.length>0;return i&&(t=t.length>0?t.add(n):n),t},item:function(t,n){var a,o,s=!1;return t=t!==i?t:S.get.values()!==i?S.get.values():S.get.text(),a=o?t.length>0:t!==i&&null!==t,o=S.is.multiple()&&e.isArray(t),n=""===t||0===t?!0:n||!1,a&&W.each(function(){var a=e(this),r=S.get.choiceText(a),l=S.get.choiceValue(a,r);if(null!==l&&l!==i)if(o)(-1!==e.inArray(String(l),t)||-1!==e.inArray(r,t))&&(s=s?s.add(a):a);else if(n){if(S.verbose("Ambiguous dropdown value using strict type check",a,t),l===t||r===t)return s=a,!0}else if(String(l)==String(t)||r==t)return S.verbose("Found select item by value",l,t),s=a,!0}),s}},check:{maxSelections:function(e){return y.maxSelections?(e=e!==i?e:S.get.selectionCount(),e>=y.maxSelections?(S.debug("Maximum selection count reached"),y.useLabels&&(W.addClass(T.filtered),S.add.message(A.maxSelections)),!0):(S.verbose("No longer at maximum selection count"),S.remove.message(),S.remove.filteredItem(),S.is.searchSelection()&&S.filterItems(),!1)):!0}},restore:{defaults:function(){S.clear(),S.restore.defaultText(),S.restore.defaultValue()},defaultText:function(){var e=S.get.defaultText(),t=S.get.placeholderText;e===t?(S.debug("Restoring default placeholder text",e),S.set.placeholderText(e)):(S.debug("Restoring default text",e),S.set.text(e))},defaultValue:function(){var e=S.get.defaultValue();e!==i&&(S.debug("Restoring default value",e),""!==e?(S.set.value(e),S.set.selected()):(S.remove.activeItem(),S.remove.selectedItem()))},labels:function(){y.allowAdditions&&(y.useLabels||(S.error(V.labels),y.useLabels=!0),S.debug("Restoring selected values"),S.create.userLabels()),S.check.maxSelections()},selected:function(){S.restore.values(),S.is.multiple()?(S.debug("Restoring previously selected values and labels"),S.restore.labels()):S.debug("Restoring previously selected values")},values:function(){S.set.initialLoad(),y.apiSettings?y.saveRemoteData?S.restore.remoteValues():S.clearValue():S.set.selected(),S.remove.initialLoad()},remoteValues:function(){var t=S.get.remoteValues();S.debug("Recreating selected from session data",t),t&&(S.is.single()?e.each(t,function(e,t){S.set.text(t)}):e.each(t,function(e,t){S.add.label(e,t)}))}},read:{remoteData:function(e){var n;return t.Storage===i?void S.error(V.noStorage):(n=sessionStorage.getItem(e),n!==i?n:!1)}},save:{defaults:function(){S.save.defaultText(),S.save.placeholderText(),S.save.defaultValue()},defaultValue:function(){var e=S.get.value();S.verbose("Saving default value as",e),P.data(D.defaultValue,e)},defaultText:function(){var e=S.get.text();S.verbose("Saving default text as",e),P.data(D.defaultText,e)},placeholderText:function(){var e;y.placeholder!==!1&&H.hasClass(T.placeholder)&&(e=S.get.text(),S.verbose("Saving placeholder text as",e),P.data(D.placeholderText,e))},remoteData:function(e,n){return t.Storage===i?void S.error(V.noStorage):(S.verbose("Saving remote data to session storage",n,e),void sessionStorage.setItem(n,e))}},clear:function(){S.is.multiple()?S.remove.labels():(S.remove.activeItem(),S.remove.selectedItem()),S.set.placeholderText(),S.clearValue()},clearValue:function(){S.set.value("")},scrollPage:function(e,t){var n,i,a,o=t||S.get.selectedItem(),s=o.closest(q.menu),r=s.outerHeight(),l=s.scrollTop(),c=W.eq(0).outerHeight(),u=Math.floor(r/c),d=(s.prop("scrollHeight"),"up"==e?l-c*u:l+c*u),v=W.not(q.unselectable);a="up"==e?v.index(o)-u:v.index(o)+u,n="up"==e?a>=0:a<v.length,i=n?v.eq(a):"up"==e?v.first():v.last(),i.length>0&&(S.debug("Scrolling page",e,i),o.removeClass(T.selected),i.addClass(T.selected),s.scrollTop(d))},set:{filtered:function(){var e=S.is.multiple(),t=S.is.searchSelection(),n=e&&t,i=t?S.get.query():"",a="string"==typeof i&&i.length>0,o=S.get.searchWidth(i.length),s=""!==i;e&&a&&(S.verbose("Adjusting input width",o,y.glyphWidth),z.css("width",o)),a||n&&s?(S.verbose("Hiding placeholder text"),H.addClass(T.filtered)):(!e||n&&!s)&&(S.verbose("Showing placeholder text"),H.removeClass(T.filtered))},loading:function(){P.addClass(T.loading)},placeholderText:function(e){e=e||S.get.placeholderText(),S.debug("Setting placeholder text",e),S.set.text(e),H.addClass(T.placeholder)},tabbable:function(){S.has.search()?(S.debug("Added tabindex to searchable dropdown"),z.val("").attr("tabindex",0),B.attr("tabindex",-1)):(S.debug("Added tabindex to dropdown"),P.attr("tabindex")===i&&(P.attr("tabindex",0),B.attr("tabindex",-1)))},initialLoad:function(){S.verbose("Setting initial load"),g=!0},activeItem:function(e){y.allowAdditions&&e.filter(q.addition).length>0?e.addClass(T.filtered):e.addClass(T.active)},scrollPosition:function(e,t){var n,a,o,s,r,l,c,u,d,v=5;e=e||S.get.selectedItem(),n=e.closest(q.menu),a=e&&e.length>0,t=t!==i?t:!1,e&&n.length>0&&a&&(s=e.position().top,n.addClass(T.loading),l=n.scrollTop(),r=n.offset().top,s=e.offset().top,o=l-r+s,t||(c=n.height(),d=o+v>l+c,u=l>o-v),S.debug("Scrolling to active item",o),(t||u||d)&&n.scrollTop(o),n.removeClass(T.loading))},text:function(e){"select"!==y.action&&("combo"==y.action?(S.debug("Changing combo button text",e,N),y.preserveHTML?N.html(e):N.text(e)):(e!==S.get.placeholderText()&&H.removeClass(T.placeholder),S.debug("Changing text",e,H),H.removeClass(T.filtered),y.preserveHTML?H.html(e):H.text(e)))},selectedLetter:function(t){var n,i=W.filter("."+T.selected),a=i.length>0&&S.has.firstLetter(i,t),o=!1;a&&(n=i.nextAll(W).eq(0),S.has.firstLetter(n,t)&&(o=n)),o||W.each(function(){return S.has.firstLetter(e(this),t)?(o=e(this),!1):void 0}),o&&(S.verbose("Scrolling to next value with letter",t),S.set.scrollPosition(o),i.removeClass(T.selected),o.addClass(T.selected))},direction:function(e){"auto"==y.direction?S.is.onScreen(e)?S.remove.upward(e):S.set.upward(e):"upward"==y.direction&&S.set.upward(e)},upward:function(e){var t=e||P;t.addClass(T.upward)},value:function(e,t,n){var a=j.length>0,o=(!S.has.value(e),S.get.values()),s=e!==i?String(e):e;if(a){if(s==o&&(S.verbose("Skipping value update already same value",e,o),!S.is.initialLoad()))return;S.is.single()&&S.has.selectInput()&&S.can.extendSelect()&&(S.debug("Adding user option",e),S.add.optionValue(e)),S.debug("Updating input value",e,o),Q=!0,j.val(e),y.fireOnInit===!1&&S.is.initialLoad()?S.debug("Input native change event ignored on initial load"):S.trigger.change(),Q=!1}else S.verbose("Storing value in metadata",e,j),e!==o&&P.data(D.value,s);y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("No callback on initial load",y.onChange):y.onChange.call(Y,e,t,n)},active:function(){P.addClass(T.active)},multiple:function(){P.addClass(T.multiple)},visible:function(){P.addClass(T.visible)},exactly:function(e,t){S.debug("Setting selected to exact values"),S.clear(),S.set.selected(e,t)},selected:function(t,n){var i=S.is.multiple();n=y.allowAdditions?n||S.get.itemWithAdditions(t):n||S.get.item(t),n&&(S.debug("Setting selected menu item to",n),S.is.single()?(S.remove.activeItem(),S.remove.selectedItem()):y.useLabels&&S.remove.selectedItem(),n.each(function(){var t=e(this),a=S.get.choiceText(t),o=S.get.choiceValue(t,a),s=t.hasClass(T.filtered),r=t.hasClass(T.active),l=t.hasClass(T.addition),c=i&&1==n.length;i?!r||l?(y.apiSettings&&y.saveRemoteData&&S.save.remoteData(a,o),y.useLabels?(S.add.value(o,a,t),S.add.label(o,a,c),S.set.activeItem(t),S.filterActive(),S.select.nextAvailable(n)):(S.add.value(o,a,t),S.set.text(S.add.variables(A.count)),S.set.activeItem(t))):s||(S.debug("Selected active value, removing label"),S.remove.selected(o)):(y.apiSettings&&y.saveRemoteData&&S.save.remoteData(a,o),S.set.text(a),S.set.value(o,a,t),t.addClass(T.active).addClass(T.selected))}))}},add:{label:function(t,n,i){var a,o=S.is.searchSelection()?z:H;return a=e("<a />").addClass(T.label).attr("data-value",t).html(E.label(t,n)),a=y.onLabelCreate.call(a,t,n),S.has.label(t)?void S.debug("Label already exists, skipping",t):(y.label.variation&&a.addClass(y.label.variation),void(i===!0?(S.debug("Animating in label",a),a.addClass(T.hidden).insertBefore(o).transition(y.label.transition,y.label.duration)):(S.debug("Adding selection label",a),a.insertBefore(o))))},message:function(t){var n=B.children(q.message),i=y.templates.message(S.add.variables(t));n.length>0?n.html(i):n=e("<div/>").html(i).addClass(T.message).appendTo(B)},optionValue:function(t){var n=j.find('option[value="'+t+'"]'),i=n.length>0;i||(x&&(x.disconnect(),S.verbose("Temporarily disconnecting mutation observer",t)),S.is.single()&&(S.verbose("Removing previous user addition"),j.find("option."+T.addition).remove()),e("<option/>").prop("value",t).addClass(T.addition).html(t).appendTo(j),S.verbose("Adding user addition as an <option>",t),x&&x.observe(j[0],{childList:!0,subtree:!0}))},userSuggestion:function(e){var t,n=B.children(q.addition),i=S.get.item(e),a=i&&i.not(q.addition).length,o=n.length>0;if(!y.useLabels||!S.has.maxSelections()){if(""===e||a)return void n.remove();W.removeClass(T.selected),o?(t=y.templates.addition(S.add.variables(A.addResult,e)),n.html(t).attr("data-"+D.value,e).attr("data-"+D.text,e).removeClass(T.filtered).addClass(T.selected),S.verbose("Replacing user suggestion with new value",n)):(n=S.create.userChoice(e),n.prependTo(B).addClass(T.selected),S.verbose("Adding item choice to menu corresponding with user choice addition",n))}},variables:function(e,t){var n,i,a=-1!==e.search("{count}"),o=-1!==e.search("{maxCount}"),s=-1!==e.search("{term}");return S.verbose("Adding templated variables to message",e),a&&(n=S.get.selectionCount(),e=e.replace("{count}",n)),o&&(n=S.get.selectionCount(),e=e.replace("{maxCount}",y.maxSelections)),s&&(i=t||S.get.query(),e=e.replace("{term}",i)),e},value:function(t,n,i){var a,o=S.get.values();return""===t?void S.debug("Cannot select blank values from multiselect"):(e.isArray(o)?(a=o.concat([t]),a=S.get.uniqueArray(a)):a=[t],S.has.selectInput()?S.can.extendSelect()&&(S.debug("Adding value to select",t,a,j),S.add.optionValue(t)):(a=a.join(y.delimiter),S.debug("Setting hidden input to delimited value",a,j)),y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("Skipping onadd callback on initial load",y.onAdd):y.onAdd.call(Y,t,n,i),S.set.value(a,t,n,i),void S.check.maxSelections())}},remove:{active:function(){P.removeClass(T.active)},activeLabel:function(){P.find(q.label).removeClass(T.active)},loading:function(){P.removeClass(T.loading)},initialLoad:function(){g=!1},upward:function(e){var t=e||P;t.removeClass(T.upward)},visible:function(){P.removeClass(T.visible)},activeItem:function(){W.removeClass(T.active)},filteredItem:function(){y.useLabels&&S.has.maxSelections()||(y.useLabels&&S.is.multiple()?W.not("."+T.active).removeClass(T.filtered):W.removeClass(T.filtered))},optionValue:function(e){var t=j.find('option[value="'+e+'"]'),n=t.length>0;n&&t.hasClass(T.addition)&&(x&&(x.disconnect(),S.verbose("Temporarily disconnecting mutation observer",e)),t.remove(),S.verbose("Removing user addition as an <option>",e),x&&x.observe(j[0],{childList:!0,subtree:!0}))},message:function(){B.children(q.message).remove()},searchTerm:function(){S.verbose("Cleared search term"),z.val(""),S.set.filtered()},selected:function(t,n){return(n=y.allowAdditions?n||S.get.itemWithAdditions(t):n||S.get.item(t))?void n.each(function(){var t=e(this),n=S.get.choiceText(t),i=S.get.choiceValue(t,n);S.is.multiple()?y.useLabels?(S.remove.value(i,n,t),S.remove.label(i)):(S.remove.value(i,n,t),0===S.get.selectionCount()?S.set.placeholderText():S.set.text(S.add.variables(A.count))):S.remove.value(i,n,t),
t.removeClass(T.filtered).removeClass(T.active),y.useLabels&&t.removeClass(T.selected)}):!1},selectedItem:function(){W.removeClass(T.selected)},value:function(e,t,n){var i,a=S.get.values();S.has.selectInput()?(S.verbose("Input is <select> removing selected option",e),i=S.remove.arrayValue(e,a),S.remove.optionValue(e)):(S.verbose("Removing from delimited values",e),i=S.remove.arrayValue(e,a),i=i.join(y.delimiter)),y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("No callback on initial load",y.onRemove):y.onRemove.call(Y,e,t,n),S.set.value(i,t,n),S.check.maxSelections()},arrayValue:function(t,n){return e.isArray(n)||(n=[n]),n=e.grep(n,function(e){return t!=e}),S.verbose("Removed value from delimited string",t,n),n},label:function(e,t){var n=P.find(q.label),i=n.filter('[data-value="'+e+'"]');S.verbose("Removing label",i),i.remove()},activeLabels:function(e){e=e||P.find(q.label).filter("."+T.active),S.verbose("Removing active label selections",e),S.remove.labels(e)},labels:function(t){t=t||P.find(q.label),S.verbose("Removing labels",t),t.each(function(){var t=e(this),n=t.data(D.value),a=n!==i?String(n):n,o=S.is.userValue(a);return y.onLabelRemove.call(t,n)===!1?void S.debug("Label remove callback cancelled removal"):void(o?(S.remove.value(a),S.remove.label(a)):S.remove.selected(a))})},tabbable:function(){S.has.search()?(S.debug("Searchable dropdown initialized"),z.removeAttr("tabindex"),B.removeAttr("tabindex")):(S.debug("Simple selection dropdown initialized"),P.removeAttr("tabindex"),B.removeAttr("tabindex"))}},has:{search:function(){return z.length>0},selectInput:function(){return j.is("select")},firstLetter:function(e,t){var n,i;return e&&0!==e.length&&"string"==typeof t?(n=S.get.choiceText(e,!1),t=t.toLowerCase(),i=String(n).charAt(0).toLowerCase(),t==i):!1},input:function(){return j.length>0},items:function(){return W.length>0},menu:function(){return B.length>0},message:function(){return 0!==B.children(q.message).length},label:function(e){var t=P.find(q.label);return t.filter('[data-value="'+e+'"]').length>0},maxSelections:function(){return y.maxSelections&&S.get.selectionCount()>=y.maxSelections},allResultsFiltered:function(){return W.filter(q.unselectable).length===W.length},query:function(){return""!==S.get.query()},value:function(t){var n=S.get.values(),i=e.isArray(n)?n&&-1!==e.inArray(t,n):n==t;return i?!0:!1}},is:{active:function(){return P.hasClass(T.active)},alreadySetup:function(){return P.is("select")&&P.parent(q.dropdown).length>0&&0===P.prev().length},animating:function(e){return e?e.transition&&e.transition("is animating"):B.transition&&B.transition("is animating")},disabled:function(){return P.hasClass(T.disabled)},focused:function(){return n.activeElement===P[0]},focusedOnSearch:function(){return n.activeElement===z[0]},allFiltered:function(){return(S.is.multiple()||S.has.search())&&!S.has.message()&&S.has.allResultsFiltered()},hidden:function(e){return!S.is.visible(e)},initialLoad:function(){return g},onScreen:function(e){var t,n=e||B,i=!0,a={};return n.addClass(T.loading),t={context:{scrollTop:M.scrollTop(),height:M.outerHeight()},menu:{offset:n.offset(),height:n.outerHeight()}},a={above:t.context.scrollTop<=t.menu.offset.top-t.menu.height,below:t.context.scrollTop+t.context.height>=t.menu.offset.top+t.menu.height},a.below?(S.verbose("Dropdown can fit in context downward",a),i=!0):a.below||a.above?(S.verbose("Dropdown cannot fit below, opening upward",a),i=!1):(S.verbose("Dropdown cannot fit in either direction, favoring downward",a),i=!0),n.removeClass(T.loading),i},inObject:function(t,n){var i=!1;return e.each(n,function(e,n){return n==t?(i=!0,!0):void 0}),i},multiple:function(){return P.hasClass(T.multiple)},single:function(){return!S.is.multiple()},selectMutation:function(t){var n=!1;return e.each(t,function(t,i){return i.target&&e(i.target).is("select")?(n=!0,!0):void 0}),n},search:function(){return P.hasClass(T.search)},searchSelection:function(){return S.has.search()&&1===z.parent(q.dropdown).length},selection:function(){return P.hasClass(T.selection)},userValue:function(t){return-1!==e.inArray(t,S.get.userValues())},upward:function(e){var t=e||P;return t.hasClass(T.upward)},visible:function(e){return e?e.hasClass(T.visible):B.hasClass(T.visible)}},can:{activate:function(e){return y.useLabels?!0:S.has.maxSelections()?S.has.maxSelections()&&e.hasClass(T.active)?!0:!1:!0},click:function(){return c||"click"==y.on},extendSelect:function(){return y.allowAdditions||y.apiSettings},show:function(){return!S.is.disabled()&&(S.has.items()||S.has.message())},useAPI:function(){return e.fn.api!==i}},animate:{show:function(t,n){var a,o=n||B,s=n?function(){}:function(){S.hideSubMenus(),S.hideOthers(),S.set.active()};t=e.isFunction(t)?t:function(){},S.verbose("Doing menu show animation",o),S.set.direction(n),a=S.get.transition(n),S.is.selection()&&S.set.scrollPosition(S.get.selectedItem(),!0),(S.is.hidden(o)||S.is.animating(o))&&("none"==a?(s(),o.transition("show"),t.call(Y)):e.fn.transition!==i&&P.transition("is supported")?o.transition({animation:a+" in",debug:y.debug,verbose:y.verbose,duration:y.duration,queue:!0,onStart:s,onComplete:function(){t.call(Y)}}):S.error(V.noTransition,a))},hide:function(t,n){var a=n||B,o=(n?.9*y.duration:y.duration,n?function(){}:function(){S.can.click()&&S.unbind.intent(),S.remove.active()}),s=S.get.transition(n);t=e.isFunction(t)?t:function(){},(S.is.visible(a)||S.is.animating(a))&&(S.verbose("Doing menu hide animation",a),"none"==s?(o(),a.transition("hide"),t.call(Y)):e.fn.transition!==i&&P.transition("is supported")?a.transition({animation:s+" out",duration:y.duration,debug:y.debug,verbose:y.verbose,queue:!0,onStart:o,onComplete:function(){"auto"==y.direction&&S.remove.upward(n),t.call(Y)}}):S.error(V.transition))}},hideAndClear:function(){S.remove.searchTerm(),S.has.maxSelections()||(S.has.search()?S.hide(function(){S.remove.filteredItem()}):S.hide())},delay:{show:function(){S.verbose("Delaying show event to ensure user intent"),clearTimeout(S.timer),S.timer=setTimeout(S.show,y.delay.show)},hide:function(){S.verbose("Delaying hide event to ensure user intent"),clearTimeout(S.timer),S.timer=setTimeout(S.hide,y.delay.hide)}},escape:{regExp:function(e){return e=String(e),e.replace(R.escape,"\\$&")}},setting:function(t,n){if(S.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,y,t);else{if(n===i)return y[t];y[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,S,t);else{if(n===i)return S[t];S[t]=n}},debug:function(){y.debug&&(y.performance?S.performance.log(arguments):(S.debug=Function.prototype.bind.call(console.info,console,y.name+":"),S.debug.apply(console,arguments)))},verbose:function(){y.verbose&&y.debug&&(y.performance?S.performance.log(arguments):(S.verbose=Function.prototype.bind.call(console.info,console,y.name+":"),S.verbose.apply(console,arguments)))},error:function(){S.error=Function.prototype.bind.call(console.error,console,y.name+":"),S.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;y.performance&&(t=(new Date).getTime(),i=u||t,n=t-i,u=t,d.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:Y,"Execution Time":n})),clearTimeout(S.performance.timer),S.performance.timer=setTimeout(S.performance.display,500)},display:function(){var t=y.name+":",n=0;u=!1,clearTimeout(S.performance.timer),e.each(d,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",l&&(t+=" '"+l+"'"),(console.group!==i||console.table!==i)&&d.length>0&&(console.groupCollapsed(t),console.table?console.table(d):e.each(d,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),d=[]}},invoke:function(t,n,a){var s,r,l,c=G;return n=n||f,a=Y||a,"string"==typeof t&&c!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,a){var o=n!=s?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(c[o])&&n!=s)c=c[o];else{if(c[o]!==i)return r=c[o],!1;if(!e.isPlainObject(c[a])||n==s)return c[a]!==i?(r=c[a],!1):(S.error(V.method,t),!1);c=c[a]}})),e.isFunction(r)?l=r.apply(a,n):r!==i&&(l=r),e.isArray(o)?o.push(l):o!==i?o=[o,l]:l!==i&&(o=l),r}},m?(G===i&&S.initialize(),S.invoke(v)):(G!==i&&G.invoke("destroy"),S.initialize())}),o!==i?o:s},e.fn.dropdown.settings={debug:!1,verbose:!1,performance:!0,on:"click",action:"activate",apiSettings:!1,saveRemoteData:!0,throttle:200,context:t,direction:"auto",keepOnScreen:!0,match:"both",fullTextSearch:!1,placeholder:"auto",preserveHTML:!0,sortSelect:!1,forceSelection:!0,allowAdditions:!1,maxSelections:!1,useLabels:!0,delimiter:",",showOnFocus:!0,allowTab:!0,allowCategorySelection:!1,fireOnInit:!1,transition:"auto",duration:200,glyphWidth:1.0714,label:{transition:"scale",duration:200,variation:!1},delay:{hide:300,show:200,search:20,touch:50},onChange:function(e,t,n){},onAdd:function(e,t,n){},onRemove:function(e,t,n){},onLabelSelect:function(e){},onLabelCreate:function(t,n){return e(this)},onLabelRemove:function(e){return!0},onNoResults:function(e){return!0},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",message:{addResult:"Add <b>{term}</b>",count:"{count} selected",maxSelections:"Max {maxCount} selections",noResults:"No results found.",serverError:"There was an error contacting the server"},error:{action:"You called a dropdown action that was not defined",alreadySetup:"Once a select has been initialized behaviors must be called on the created ui dropdown",labels:"Allowing user additions currently requires the use of labels.",missingMultiple:"<select> requires multiple property to be set to correctly preserve multiple values",method:"The method you called is not defined.",noAPI:"The API module is required to load resources remotely",noStorage:"Saving remote data requires session storage",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>"},regExp:{escape:/[-[\]{}()*+?.,\\^$|#\s]/g},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",placeholderText:"placeholder",text:"text",value:"value"},fields:{remoteValues:"results",values:"values",name:"name",value:"value"},keys:{backspace:8,delimiter:188,deleteKey:46,enter:13,escape:27,pageUp:33,pageDown:34,leftArrow:37,upArrow:38,rightArrow:39,downArrow:40},selector:{addition:".addition",dropdown:".ui.dropdown",icon:"> .dropdown.icon",input:'> input[type="hidden"], > select',item:".item",label:"> .label",remove:"> .label > .delete.icon",siblingLabel:".label",menu:".menu",message:".message",menuIcon:".dropdown.icon",search:"input.search, .menu > .search > input",text:"> .text:not(.icon)",unselectable:".disabled, .filtered"},className:{active:"active",addition:"addition",animating:"animating",disabled:"disabled",dropdown:"ui dropdown",filtered:"filtered",hidden:"hidden transition",item:"item",label:"ui label",loading:"loading",menu:"menu",message:"message",multiple:"multiple",placeholder:"default",search:"search",selected:"selected",selection:"selection",upward:"upward",visible:"visible"}},e.fn.dropdown.settings.templates={dropdown:function(t){var n=t.placeholder||!1,i=(t.values||{},"");return i+='<i class="dropdown icon"></i>',i+=t.placeholder?'<div class="default text">'+n+"</div>":'<div class="text"></div>',i+='<div class="menu">',e.each(t.values,function(e,t){i+=t.disabled?'<div class="disabled item" data-value="'+t.value+'">'+t.name+"</div>":'<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),i+="</div>"},menu:function(t,n){var i=t[n.values]||{},a="";return e.each(i,function(e,t){a+='<div class="item" data-value="'+t[n.value]+'">'+t[n.name]+"</div>"}),a},label:function(e,t){return t+'<i class="delete icon"></i>'},message:function(e){return e},addition:function(e){return e}}}(jQuery,window,document);